<?php /*Template Name: profile edit */ ?>
<?php
global $wpdb, $current_user, $wp_roles;
$userId = get_current_user_id();
if (!is_user_logged_in()) :
    $home = esc_url(home_url(''));
    header("Location: $home");
    exit;
endif;
?>
<?php get_header(); ?>

<section class="content deletplaceholder">
    <div class="container">
        <h1 class="sec-tit text-center">
            <?php the_title(); ?>
            ( <?php echo $current_user->nickname; ?>)
        </h1>

        <?php echo do_shortcode('[basic-user-avatars]'); ?>

        <form action="" method="post">
            <div class="form-group">
                <label for="nickname"> <?php _e('اسم المستخدم', 'm7md') ?></label>
                <input id="nickname"
                       class="form-control"
                       name="com_fullname"
                       type="text"
                       value="<?php echo get_the_author_meta('nickname', $userId); ?>"
                       disabled>
            </div>
            <div class="form-group">
                <label for="firstname"><?php _e('الأسم', 'm7md') ?></label>
                <input id="firstname"
                       class="form-control"
                       name="com_firstname"
                       type="text"
                       value="<?php echo get_the_author_meta('first_name', $userId); ?>"
                       placeholder="<?php _e('برجاء ادخال الاسم', 'm7md') ?>">
            </div>
            <div class="form-group">
                <label for="email"> <?php _e('البريد الالكترونى', 'm7md') ?></label>
                <input id="email"
                       class="form-control"
                       name="com_email"
                       type="email"
                       value="<?php the_author_meta('user_email', $current_user->ID); ?>">
            </div>
            <div class="form-group">
                <label for="phone"><?php _e(' رقم الجوال', 'm7md') ?></label>
                <input id="phone"
                       class="form-control"
                       name="com_mobile"
                       type="text"
                       value="<?php echo get_the_author_meta('user_mobile', $userId); ?>"
                       placeholder="<?php _e('برجاء ادخال رقم الجوال', 'm7md') ?>">
            </div>
            <div class="form-group">
                <label for="user_mycitynow">
                       <?php _e("<!--:en--> Country of Residence <!--:--><!--:ar-->  بلد الإقامة<!--:-->"); ?> :
                </label>
                <input readonly id="specialty"
                       class="form-control"
                       name="user_mycitynow"
                       type="text"
                       value="<?php echo get_the_author_meta('user_mycitynow', $userId); ?>"
                       placeholder="   <?php _e("<!--:en--> Country of Residence <!--:--><!--:ar-->  بلد الإقامة<!--:-->"); ?>">
            </div>
            <?php if (get_field('user_membership', 'user_' . $current_user->ID) == 'instructor'): ?>
            <div class="form-group">
                <div class="col-form-label">
                    <?php _e("هل لديك عضوية (سارية) في الجمعية؟", "m7md"); ?>
                </div>
                <div class="custom-control custom-radio">
                    <input type="radio"
                           class="custom-control-input"
                           id="user_member_talented"
                           name="com_member_type"
                           value="نعم، عضوية عاملة"
                        <?php if (get_the_author_meta('user_member_type', $current_user->ID) === "نعم، عضوية عاملة") {
                            echo "checked";
                        }
                        ?>
                           required>
                    <label class="custom-control-label"
                           for="user_member_talented">
                        <?php _e("نعم، عضوية عاملة", "m7md"); ?>
                    </label>
                </div>
                
                <div class="custom-control custom-radio">
                    <input type="radio"
                           class="custom-control-input"
                           id="user_member_kids"
                           name="com_member_type"
                           value="نعم، عضوية انتساب"
                        <?php if (get_the_author_meta('user_member_type', $current_user->ID) === "نعم، عضوية انتساب") {
                            echo "checked";
                        }
                        ?>
                           required>
                    <label class="custom-control-label"
                           for="user_member_kids">
                        <?php _e("نعم، عضوية انتساب", "m7md"); ?>
                    </label>
                </div>
                <div class="custom-control custom-radio">
                    <input type="radio"
                           class="custom-control-input"
                           id="user_member_others"
                           name="com_member_type"
                           value="لست عضو بالجمعية"
                        <?php if (get_the_author_meta('user_member_type', $current_user->ID) === "لست عضو بالجمعية") {
                            echo "checked";
                        }
                        ?>
                           required>
                    <label class="custom-control-label"
                           for="user_member_others">
                        <?php _e("لست عضو بالجمعية", "m7md"); ?>
                    </label>
                </div>
            </div>
            <div class="form-group">
                <label for="user_site"><?php _e('رقم التصنيف ان وجد', 'm7md') ?></label>
                <input id="user_site"
                       class="form-control"
                       name="com_classificationNum"
                       type="text"
                       value="<?php echo get_the_author_meta('user_classificationNum', $userId); ?>"
                       placeholder="<?php _e('رقم التصنيف ان وجد', 'm7md') ?>">
            </div>
            <div class="form-group">
                <label for="job"><?php _e(' الوظيفة', 'm7md') ?></label>
                <input id="job"
                       class="form-control"
                       name="com_job"
                       type="text"
                       value="<?php echo get_the_author_meta('user_job', $userId); ?>"
                       placeholder="<?php _e('الوظيفة', 'm7md') ?>">
            </div>
            <?php endif; ?>

            <div class="d-flex justify-content-between">



                        <button  type="submit"
                        class='main-button'
                        name="com_submit">
                            <span><?php _e('حفظ التعديلات ', 'm7md') ?></span>
                            <?php the_switch_language('<i class="fa-solid fa-arrow-left-long"></i>',
                                '<i class="fa-solid fa-arrow-right-long"></i>') ?>
                        </button>
                        
                        
                <a  class='main-button'
                   href="<?php echo get_page_link(86) ?>">
                    <span><?php _e('تغيير كلمة المرور', 'm7md') ?></span>
                    <?php the_switch_language('<i class="fa-solid fa-arrow-left-long"></i>',
                                '<i class="fa-solid fa-arrow-right-long"></i>') ?>
                </a>
            </div>



        </form>

        <?php

        if (isset($_POST['com_submit'])) {
            if ($_POST['com_firstname']) {
                update_user_meta($userId, 'first_name', $_POST['com_firstname']);
            }

            if ($_POST['com_email']) {
                update_user_meta($userId, 'user_email', $_POST['com_email']);
            }
            if ($_POST['com_mobile']) {
                update_user_meta($userId, 'user_mobile', $_POST['com_mobile']);
            }
            if ($_POST['com_job']) {
                update_user_meta($userId, 'user_job', $_POST['com_job']);
            }

            if ($_POST['com_specialty']) {
                update_user_meta($userId, 'user_specialty', $_POST['com_specialty']);
            }

            if ($_POST['com_classificationNum']) {
                update_user_meta($userId, 'user_classificationNum', $_POST['com_classificationNum']);
            }
            if ($_POST['com_member_type']) {
                update_user_meta($userId, 'user_member_type', $_POST['com_member_type']);
            }

            if ($_POST['com_email']) {
                $args = array(
                    'ID' => $userId,
                    'user_email' => esc_attr($_POST['com_email'])
                );
                wp_update_user($args);
            }
            $url = get_page_link(88);
            wp_redirect($url);// redirect to home page
        }
        ?>

    </div>
</section>


<?php get_footer(); ?>
